<?php

// PHP part
$current_year = date('Y');

$current_month = date('m');

$selected_ten_kh = isset($_GET['ten_kh']) ? $_GET['ten_kh'] : '';

$selected_so_cont = isset($_GET['So_cont']) ? $_GET['So_cont'] : '';

$selected_nha_xe = isset($_GET['nha_xe']) ? $_GET['nha_xe'] : '';

$selected_xe_nha = isset($_GET['So_xe']) ? $_GET['So_xe'] : '';

$selected_bien_so = isset($_GET['bien_so_xe']) ? $_GET['bien_so_xe'] : '';

$selected_ngay_thang = isset($_GET['ngay_thang']) ? $_GET['ngay_thang'] : $current_month;

$selected_year = isset($_GET['year']) ? $_GET['year'] : $current_year;

$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

$records_per_page = isset($_GET['records_per_page']) ? (int)$_GET['records_per_page'] : 50;



$congno_data_filtered = array_filter($congno_data, function ($row) use ($selected_ten_kh, $selected_so_cont, $selected_nha_xe, $selected_xe_nha, $selected_bien_so, $selected_ngay_thang, $selected_year) {

    $row_ten_kh = $row['Ten_KH'];

    $row_so_cont = $row['So_cont'];

    $row_nha_xe = $row['Nha_xe'];

    $row_xe_nha = $row['So_xe'];

    $row_bien_so = $row['bien_so_xe'];

    $row_ngay_thang = substr($row['Ngay_ghi_so'], 5, 2);

    $row_year = (int)substr($row['Ngay_ghi_so'], 0, 4);

    $ten_kh_condition = $selected_ten_kh === '' || $row_ten_kh === $selected_ten_kh;

    $so_cont_condition = $selected_so_cont === '' || $row_so_cont === $selected_so_cont;

    $nha_xe_condition = $selected_nha_xe === '' || $row_nha_xe === $selected_nha_xe;

    $xe_nha_condition = $selected_xe_nha === '' || $row_xe_nha === $selected_xe_nha;

    $bien_so_condition = $selected_bien_so === '' || $row_bien_so === $selected_bien_so;

    $ngay_thang_condition = $row_ngay_thang === $selected_ngay_thang;

    $nam_condition = $row_year === $selected_year;

    return $ten_kh_condition && $so_cont_condition && $nha_xe_condition && $xe_nha_condition && $bien_so_condition && $ngay_thang_condition && $nam_condition;

});



usort($congno_data_filtered, function ($a, $b) {

    return strtotime($b['Ngay_ghi_so']) - strtotime($a['Ngay_ghi_so']);

});

$total_records = count($congno_data_filtered);

$total_pages = ceil($total_records / $records_per_page);

$start_index = ($current_page - 1) * $records_per_page;

$end_index = min($start_index + $records_per_page, $total_records);

$paginated_data = array_slice($congno_data_filtered, $start_index, $records_per_page);



function buildQueryString($params, $additional_params = []) {

    $query = array_merge($params, $additional_params);

    return http_build_query($query);

}



function generatePaginationControls($current_page, $total_pages, $records_per_page, $query_params) {

    $controls = '<ul class="pagination">';

    for ($i = 1; $i <= $total_pages; $i++) {

        $additional_params = ['page' => $i, 'records_per_page' => $records_per_page];

        $query_string = buildQueryString($query_params, $additional_params);

        if ($i == $current_page) {

            $controls .= '<li class="active"><a href="#">' . $i . '</a></li>';

        } else {

            $controls .= '<li><a href="?' . $query_string . '">' . $i . '</a></li>';

        }

    }

    $controls .= '</ul>';

    return $controls;

}



// Extract query parameters

$query_params = [

    'ten_kh' => isset($_GET['ten_kh']) ? $_GET['ten_kh'] : '',

    'So_cont' => isset($_GET['So_cont']) ? $_GET['So_cont'] : '',

    'nha_xe' => isset($_GET['nha_xe']) ? $_GET['nha_xe'] : '',

    'So_xe' => isset($_GET['So_xe']) ? $_GET['So_xe'] : '',

    'bien_so_xe' => isset($_GET['bien_so_xe']) ? $_GET['bien_so_xe'] : '',

    'ngay_thang' => isset($_GET['ngay_thang']) ? $_GET['ngay_thang'] : $current_month,

    'year' => isset($_GET['year']) ? $_GET['year'] : $current_year

    

];



$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

$records_per_page = isset($_GET['records_per_page']) ? (int)$_GET['records_per_page'] : 50;



$congno_data_filtered = array_filter($congno_data, function ($row) use ($query_params) {

    $row_ten_kh = $row['Ten_KH'];

    $row_so_cont = $row['So_cont'];

    $row_nha_xe = $row['Nha_xe'];

    $row_xe_nha = $row['So_xe'];

    $row_bien_so = $row['bien_so_xe'];

    $row_ngay_thang = substr($row['Ngay_ghi_so'], 5, 2);

    $row_year = substr($row['Ngay_ghi_so'], 0, 4);

    $ten_kh_condition = $query_params['ten_kh'] === '' || $row_ten_kh === $query_params['ten_kh'];

    $so_cont_condition = $query_params['So_cont'] === '' || $row_so_cont === $query_params['So_cont'];

    $nha_xe_condition = $query_params['nha_xe'] === '' || $row_nha_xe === $query_params['nha_xe'];

    $xe_nha_condition = $query_params['So_xe'] === '' || $row_xe_nha === $query_params['So_xe'];

    $bien_so_condition = $query_params['bien_so_xe'] === '' || $row_bien_so === $query_params['bien_so_xe'];

    $ngay_thang_condition = $query_params['ngay_thang'] === '' || $row_ngay_thang === $query_params['ngay_thang'];

    $nam_condition = $row_year === $query_params['year'];


    return $ten_kh_condition && $so_cont_condition && $nha_xe_condition && $xe_nha_condition && $bien_so_condition && $ngay_thang_condition && $nam_condition; 

});



usort($congno_data_filtered, function ($a, $b) {

    return strtotime($a['Ngay_ghi_so']) - strtotime($b['Ngay_ghi_so']);

});



$total_records = count($congno_data_filtered);

$total_pages = ceil($total_records / $records_per_page);

$start_index = ($current_page - 1) * $records_per_page;

$end_index = min($start_index + $records_per_page, $total_records);

$paginated_data = array_slice($congno_data_filtered, $start_index, $records_per_page);

$future_date_count = 0;

foreach ($paginated_data as $row) {

    $current_date = date('Y-m-d');

    $record_date = date('Y-m-d', strtotime($row['Ngay_ghi_so']));

    if ($record_date > $current_date) {

        $future_date_count++;

    }

}

?>