                                            <?php

                                            // Initialize variables and retrieve query parameters
                                            $current_year = date('Y');

                                            $current_month = date('m');

                                            $staff_ids = array_column($staff, 'staffid');

                                            $selected_ten_kh = isset($_GET['ten_kh']) ? $_GET['ten_kh'] : '';

                                            $selected_so_cont = isset($_GET['so_cont']) ? $_GET['so_cont'] : '';

                                            $selected_so_xe = isset($_GET['so_xe']) ? $_GET['so_xe'] : $staff_ids[1]; // Corrected index to 0 for default value

                                            $selected_ngay_thang = isset($_GET['ngay_thang']) ? $_GET['ngay_thang'] : $current_month;

                                            $selected_year = isset($_GET['year']) && is_numeric($_GET['year']) ? (int)$_GET['year'] : (int)$current_year;

                                            $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;

                                            $records_per_page = isset($_GET['records_per_page']) ? (int)$_GET['records_per_page'] : 50;



                                            // Filter and sort data

                                            $congno_data_filtered = array_filter($luong_data, function ($row) use ($selected_ten_kh, $selected_so_cont, $selected_so_xe, $selected_ngay_thang, $selected_year) {

                                                $row_ten_kh = $row['Ten_KH'];

                                                $row_so_cont = $row['So_cont'];

                                                $row_so_xe = $row['So_xe'];

                                                $row_ngay_thang = substr($row['Ngay_ghi_so'], 5, 2);

                                                $row_year = (int)substr($row['Ngay_ghi_so'], 0, 4);

                                                $ten_kh_condition = $selected_ten_kh === '' || $row_ten_kh === $selected_ten_kh;

                                                $so_cont_condition = $selected_so_cont === '' || $row_so_cont === $selected_so_cont;

                                                $so_xe_condition = $selected_so_xe === '' || $row_so_xe === $selected_so_xe;

                                                $ngay_thang_condition = $row_ngay_thang === $selected_ngay_thang;

                                                $nam_condition = $row_year === $selected_year;

                                                return $ten_kh_condition && $so_cont_condition && $so_xe_condition && $ngay_thang_condition && $nam_condition;

                                            });



                                            usort($congno_data_filtered, function ($a, $b) {

                                                return strtotime($a['Ngay_ghi_so']) - strtotime($b['Ngay_ghi_so']);

                                            });



                                            // Pagination setup

                                            $total_records = count($congno_data_filtered);

                                            $total_pages = ceil($total_records / $records_per_page);

                                            $start_index = ($current_page - 1) * $records_per_page;

                                            $end_index = min($start_index + $records_per_page, $total_records);

                                            $paginated_data = array_slice($congno_data_filtered, $start_index, $records_per_page);



                                            // Function to build query string for pagination links

                                            function buildQueryString($params) {

                                                return http_build_query($params);

                                            }



                                            // Generate pagination controls

                                            function generatePaginationControls($current_page, $total_pages, $records_per_page, $query_params) {

                                                $controls = '<ul class="pagination">';

                                                for ($i = 1; $i <= $total_pages; $i++) {

                                                    $query_params['page'] = $i; // Update 'page' parameter for each page number

                                                    $query_string = buildQueryString($query_params);

                                                    if ($i == $current_page) {

                                                        $controls .= '<li class="active"><a href="#">' . $i . '</a></li>';

                                                    } else {

                                                        $controls .= '<li><a href="?' . $query_string . '">' . $i . '</a></li>';

                                                    }

                                                }

                                                $controls .= '</ul>';

                                                return $controls;

                                            }



                                            // Extract query parameters for pagination links

                                            $query_params = [

                                                'ten_kh' => $selected_ten_kh,

                                                'so_cont' => $selected_so_cont,

                                                'so_xe' => $selected_so_xe,

                                                'ngay_thang' => $selected_ngay_thang,

                                                'year' => $selected_year,

                                                'records_per_page' => $records_per_page

                                            ];

                                            


                                             //HÀM TÍNH TOÁN SỐ LIỆu THỐNG KÊ

                                                $tong_luong = array_sum(array_map(function($row) {

                                                    $Luong_chuyen = floatval($row['Luong_chuyen']);

                                                    $MOOC = floatval($row['MOOC']);

                                                    $Ngoai_tinh = floatval($row['Ngoai_tinh']);

                                                    $CAP = floatval($row['CAP']);

                                                    $NEO = floatval($row['NEO']);

                                                    $LANH = floatval($row['LANH']);

                                                    $D_THOAI = floatval($row['D_THOAI']);

                                                    $Khac = floatval($row['Khac']);

                                                    if (!empty($Luong_chuyen)) {

                                                        return $Luong_chuyen + $Ngoai_tinh + $CAP + $NEO + $LANH + $D_THOAI + $Khac;

                                                    } else {

                                                        if ($MOOC == 1) {

                                                            return 850000 + $Ngoai_tinh + $CAP + $NEO + $LANH + $D_THOAI + $Khac;

                                                        } elseif ($MOOC == 1.5) {

                                                            return 1275000 + $Ngoai_tinh + $CAP + $NEO + $LANH + $D_THOAI + $Khac;

                                                        } else {

                                                            return 0 + $Ngoai_tinh + $CAP + $NEO + $LANH + $D_THOAI + $Khac;

                                                        }

                                                    }

                                                }, $congno_data_filtered)); 



                                                $tong_ung = array_sum(array_column($congno_data_filtered, 'UNG'));

                                                $quyet_toan = array_sum(array_column($congno_data_filtered, 'QTOAN'));

                                                $hoan_ung = $tong_ung - $quyet_toan;

                                                $con_lai = $tong_luong - $hoan_ung - array_reduce($staff, function ($carry, $staffs) use ($selected_so_xe) {

                                                    if ($staffs['staffid'] == $selected_so_xe) {

                                                        return $carry + floatval($staffs['birthplace']);

                                                    }

                                                    return $carry;

                                                }, 0);

                                            ?>