<?php

defined('BASEPATH') or exit('No direct script access allowed');



class Template_module1_model extends CI_Model

{

    public function __construct()

    {

        parent::__construct();

    }



    public function get_congno_data()

    {

        $this->db->select('congno.*, tblclients.company as Ten_KH');

        $this->db->from(db_prefix() . 'congno as congno');

        $this->db->join(db_prefix() . 'clients as tblclients', 'congno.MA_KH = tblclients.userid', 'left');

        return $this->db->get()->result_array();

    }

    public function insert_expense_data($data)
        {
            $this->db->insert(db_prefix() . 'expenses', $data);
        }



    public function get_clients()

    {

        return $this->db->get(db_prefix() . 'clients')->result_array();

    }

    public function get_expense_by_congno($congno_id)
    {
        return $this->db->where('congno_id', $congno_id)
                        ->get(db_prefix() . 'expenses')
                        ->result_array();
    }


    public function get_status()

    {

        return $this->db->get(db_prefix() . 'leads_status')->result_array();

    }

    public function get_xenha()

    {

        return $this->db->get(db_prefix() . 'leads_sources')->result_array();

    }

    public function insert_congno($data)

    {

        $this->db->insert(db_prefix() . 'congno', $data);

        return $this->db->insert_id();

    }

    public function insert_expense($data)

    {

        $this->db->insert(db_prefix() . 'expenses', $data);

        return $this->db->insert_id();

    }

    public function update_congno_data($id, $data)

    {

        $this->db->where('id', $id);

        $this->db->update(db_prefix() . 'congno', $data);

    }

    public function update_expense_data($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'expenses', [
            'expense_name' => $data['expense_name'], // có thể là ''
            'amount'       => $data['amount'],       // có thể là 0 hoặc ''
            'note'         => $data['note'],         // có thể là ''
        ]);
    }


    public function get_congno_by_id($id)

    {

        return $this->db->get_where(db_prefix() . 'congno', array('id' => $id))->row();

    }

   
    public function get_xenha_by_id($id)

    {

        return $this->db->get_where(db_prefix() . 'leads_sources', array('id' => $id))->row();

    }



    public function delete_congno($id)

    {

        $this->db->delete(db_prefix() . 'congno', array('id' => $id));

    }



    public function update_field($id, $field, $value)

    {

        $this->db->where('id', $id);

        $this->db->update(db_prefix() . 'congno', array($field => $value));

    }



    public function get_filtered_data($filter_MA_KH = '', $filter_So_cont = '')

    {

        $this->db->select('congno.*, tblclients.company as Ten_KH');

        $this->db->from(db_prefix() . 'congno as congno');

        $this->db->join(db_prefix() . 'clients as tblclients', 'congno.MA_KH = tblclients.userid', 'left');



        if (!empty($filter_MA_KH)) {

            $this->db->where('congno.MA_KH', $filter_MA_KH);

        }



        if (!empty($filter_So_cont)) {

            $this->db->where('congno.So_cont', $filter_So_cont);

        }



        return $this->db->get()->result_array();

    }

    

    public function get_staff_data()

    {

        return $this->db->get(db_prefix() . 'staff')->result_array();

    }



  public function sync_salary_table()
{
    // === PHẦN 1: ĐỒNG BỘ DỮ LIỆU CƠ BẢN TỪ `congno` sang `cluong` ===

    // Thêm mới hoặc cập nhật bản ghi từ `congno` sang `cluong`
    $query_sync_base = "
        INSERT INTO " . db_prefix() . "cluong (id, MA_KH, Ngay_ghi_so, So_cont, Diem_di, Diem_den, Loai_cont, So_xe, bien_so_xe, manual_entry)
        SELECT id, MA_KH, Ngay_ghi_so, So_cont, Diem_di, Diem_den, Loai_cont, So_xe, bien_so_xe, 0
        FROM " . db_prefix() . "congno
        ON DUPLICATE KEY UPDATE
            MA_KH = VALUES(MA_KH),
            Ngay_ghi_so = VALUES(Ngay_ghi_so),
            So_cont = VALUES(So_cont),
            Diem_di = VALUES(Diem_di),
            Diem_den = VALUES(Diem_den),
            Loai_cont = VALUES(Loai_cont),
            So_xe = VALUES(So_xe),
            bien_so_xe = VALUES(bien_so_xe)
    ";
    $this->db->query($query_sync_base);

    // Xóa các bản ghi `cluong` không còn tồn tại trong `congno`
    $cluong_ids = $this->db->select('id')->where('manual_entry', 0)->get(db_prefix() . 'cluong')->result_array();
    if (count($cluong_ids) > 0) {
        $cluong_id_array = array_column($cluong_ids, 'id');
        $congno_ids = $this->db->select('id')->get(db_prefix() . 'congno')->result_array();
        $congno_id_array = array_column($congno_ids, 'id');
        $ids_to_delete = array_diff($cluong_id_array, $congno_id_array);

        if (!empty($ids_to_delete)) {
            $this->db->where_in('id', $ids_to_delete)
                     ->where('manual_entry', 0)
                     ->delete(db_prefix() . 'cluong');
        }
    }

    // === PHẦN 2: ĐỒNG BỘ CHI PHÍ TỪ `expenses` SANG `cluong` ===

    // 1. Lấy tất cả chi phí liên quan đến các chuyến xe có tài xế
    $this->db->select('e.congno_id, e.expense_name, e.amount');
    $this->db->from(db_prefix() . 'expenses as e');
    $this->db->join(db_prefix() . 'congno as c', 'e.congno_id = c.id');
    $this->db->where('c.So_xe IS NOT NULL');
    $this->db->where('c.So_xe !=', '');
    $all_expenses = $this->db->get()->result_array();

    // 2. Phân loại chi phí theo từ khóa
    $cluong_updates = [];
    $expense_map = [
        'ngoài tỉnh'  => 'Ngoai_tinh',
        'ngoai tinh'  => 'Ngoai_tinh',
        'cặp'         => 'CAP',
        'cap'         => 'CAP',
        'neo'         => 'NEO',
        'lạnh'        => 'LANH',
        'lanh'        => 'LANH',
        'điện thoại'  => 'D_THOAI',
        'dien thoai'  => 'D_THOAI',
    ];

    foreach ($all_expenses as $expense) {
        $congno_id = $expense['congno_id'];
        $amount = (float)$expense['amount'];
        $name = mb_strtolower(trim($expense['expense_name']), 'UTF-8');

        // Khởi tạo nếu chưa có
        if (!isset($cluong_updates[$congno_id])) {
            $cluong_updates[$congno_id] = [
                'id'         => $congno_id,
                'Ngoai_tinh' => 0,
                'CAP'        => 0,
                'NEO'        => 0,
                'LANH'       => 0,
                'D_THOAI'    => 0,
                'Khac'       => 0,
            ];
        }

        $target_column = 'Khac';
        foreach ($expense_map as $keyword => $column) {
            if (strpos($name, $keyword) !== false) {
                $target_column = $column;
                break;
            }
        }

        $cluong_updates[$congno_id][$target_column] += $amount;
    }

    // 3. Cập nhật vào bảng cluong — chỉ update nếu giá trị hiện tại đang là 0
    if (!empty($cluong_updates)) {
        foreach ($cluong_updates as $update) {
            $sets = [];
            foreach (['Ngoai_tinh', 'CAP', 'NEO', 'LANH', 'D_THOAI', 'Khac'] as $col) {
                if ($update[$col] > 0) {
                    // Chỉ cập nhật nếu giá trị hiện tại là 0
                    $sets[] = "$col = IF($col = 0, {$update[$col]}, $col)";
                }
            }
            if (!empty($sets)) {
                $set_sql = implode(', ', $sets);
                $sql = "UPDATE " . db_prefix() . "cluong SET $set_sql WHERE id = " . (int)$update['id'] . " AND manual_entry = 0";
                $this->db->query($sql);
            }
        }
    }
}

    



}

