<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Chi Tiết Công Nợ Custom
Description: Chi Tiết Công Nợ
Version: 1.0.0
Requires at least: 2.3.*
Author: Bao
*/

define('TEMPLATE_MODULE1_NAME', 'template_module1');

hooks()->add_action('admin_init', 'template_module1_init_menu_items');
hooks()->add_action('customers_navigation_end', 'customers_navigation_template_module1');

/**
 * Register activation module hook
 */
register_activation_hook(TEMPLATE_MODULE1_NAME, 'template_module1_activation_hook');

function template_module1_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}



/**
 * Init template module 1 menu items in setup in admin_init hook
 * @return null
 */
function template_module1_init_menu_items()
{
    /**
     * If the logged-in user is an administrator, add a custom menu in Setup
     */
    // if (is_admin()) {
        $CI = &get_instance();

        $CI->app_menu->add_sidebar_menu_item('template_module1_menu', [
            'name'     => _l('Bảng Chi Tiết Công Nợ'),
            'href'     => admin_url('template_module1'),
            'icon'     => 'fa-solid fa-table',
            'position' => 5,
        ]);
    // }
}

function customers_navigation_template_module1()
{
    echo '<li><a href="' . admin_url('template_module1/template_module1_client') . '">' . _l('template_module1_menu') . '</a></li>';
}
